﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Config
{
    public partial class UCTabEduFarma : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        public UCTabEduFarma()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCOptionsDetails UCDetails
        {
            get { return (UCOptionsDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            _gftpControlImageFileID.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlImageFileID.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlImageFileID.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(ImageChanged);
            _gPictureBox.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
        }

        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            Gemini.Core.WinForms.Controls.GPictureBox _gPictureBox = sender as Gemini.Core.WinForms.Controls.GPictureBox;

            if (_gPictureBox != null)
            {
                _gPictureBox.Visible = true;
            }

        }

        void ImageChanged()
        {
            if (_gftpControlImageFileID.IsFileExist)
            {
                _gPictureBox.Visible = false;
                _gPictureBox.LoadAsync(_gftpControlImageFileID.URL);
            }
            else
            {
                _gPictureBox.Visible = false;
            }
        }

        public override bool DoSave()
        {
            bool _return = true;

            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.eduFarma.AdminAddress, BL.Dictionary.Clients.PlugIn, _gTextBoxAdministrationPanelAdress.Text);
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.eduFarma.GameAddress, BL.Dictionary.Clients.PlugIn, _gTextBoxAddress.Text);

            if (_gftpControlImageFileID.IsFileExist)
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.eduFarma.ImageID, BL.Dictionary.Clients.PlugIn, _gftpControlImageFileID.ID);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.eduFarma.ImageURL, BL.Dictionary.Clients.PlugIn, _gftpControlImageFileID.URL);
            }
            else
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.eduFarma.ImageID, BL.Dictionary.Clients.PlugIn, (long?)null);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.eduFarma.ImageURL, BL.Dictionary.Clients.PlugIn,String.Empty);
            }

            return _return;
        }

        public override void DoRestore()
        {
            _gTextBoxAdministrationPanelAdress.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.AdminAddress, BL.Dictionary.Clients.PlugIn, String.Empty);
            _gTextBoxAddress.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.GameAddress, BL.Dictionary.Clients.PlugIn, String.Empty);
            _gftpControlImageFileID.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.eduFarma.ImageID, BL.Dictionary.Clients.PlugIn);

            _gPictureBox.Visible = false;
            if (_gftpControlImageFileID.ID.HasValue)
            {
                string _imageURL = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.ImageURL, BL.Dictionary.Clients.PlugIn);
                if (!String.IsNullOrEmpty(_imageURL))
                {
                    _gPictureBox.Visible = false;
                    _gPictureBox.LoadAsync(_imageURL);
                }
            }
        }
    }
}
